/*****************************************************************************
*
* Copyright 2019 NXP
* All Rights Reserved
*
*****************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/

/*!*********************************************************************************
*  @file    orbmatchdescriptors_graph.hpp
*  @brief   ACF graph
***********************************************************************************/

#ifndef ORBMATCHDESCRIPTORSGRAPH_HPP
#define ORBMATCHDESCRIPTORSGRAPH_HPP

#include <acf_graph.hpp>

#ifdef APEX2_EMULATE
#include "acf_lib.hpp"
using namespace APEX2;
#endif

#include "orbmatchdescriptors_graph_names.h"

#include "match_descriptors_acf.h"

class OrbMatchDescriptorsGraph: public ACF_Graph
{
public:
  OrbMatchDescriptorsGraph() : ACF_Graph()
  {
    XREGISTER_ACF_KERNEL(MATCH_DESCRIPTORS_K);
  }

  void Create()
  {
    //set identifier for graph
    SetIdentifier("OrbMatchDescriptorsGraph");

    //add kernels
    const std::string match_descriptors_0("match_descriptors_0");
    AddKernel(match_descriptors_0, MATCH_DESCRIPTORS_KN);

    //add graph ports
    AddInputPort(GR_INPUT1_IN);
    AddInputPort(GR_INPUT0_IN);
    AddInputPort(GR_INPUTCONFIG_IN);
    AddOutputPort(GR_OUTPUT0_OUT);
    AddOutputPort(GR_OUTPUT1_OUT);

    //specify connections
    Connect(GraphPort(GR_INPUT1_IN), KernelPort(match_descriptors_0, MATCH_DESCR_KN_IN1));
    Connect(GraphPort(GR_INPUT0_IN), KernelPort(match_descriptors_0, MATCH_DESCR_KN_IN0));
    Connect(GraphPort(GR_INPUTCONFIG_IN), KernelPort(match_descriptors_0, MATCH_DESCR_KN_CFG));
    Connect(KernelPort(match_descriptors_0, MATCH_DESCR_KN_OUT0), GraphPort(GR_OUTPUT0_OUT));
    Connect(KernelPort(match_descriptors_0, MATCH_DESCR_KN_OUT1), GraphPort(GR_OUTPUT1_OUT));
  }
};

#endif /* ORBMATCHDESCRIPTORSGRAPH_HPP */
